############################################################################
########################	   function define       #######################
############################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

library(amap)
error.bar <- function(x, y, upper, lower=upper, length=0.1,...){
  if(length(x) != length(y) | length(y) !=length(lower) | length(lower) != length(upper))
    stop("vectors must be same length")
  arrows(x,y+upper, x, y-lower, angle=90, code=3, length=length, ...)
}


NaivePrimedGeneBarplot <- function(genes){
	for(each in genes){
		plot_matrix <- as.matrix(rbind(pData[each,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")],nData[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")]))
		ymax <- max(plot_matrix)
		plot_sd <- rbind(c(0,0,0,0,0,0,0,0,0),n_log_sd[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")])
		bp <- barplot(plot_matrix,beside=T,col=c(cccol[2],cccol[1]),main=each,ylab="log2(fpkm+1)",names.arg=common_time_point,las=2,bty="l",border = NA,ylim=c(0,ymax*1.3))
		n <- c(2,2,2,3,3,3,2,2,2)
		error.bar(bp,plot_matrix, 1.96 * plot_sd / sqrt(n),col="black",length=0.02,lwd=1)
		legend("topleft",c("naive","primed"),col=c(cccol[1],cccol[2]),pch=15,bty="n")

		plot_matrix <- as.matrix(rbind(pData2ndfpkm[each,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")],nData2ndfpkm[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")]))
		ymax <- max(plot_matrix)
		plot_sd <- rbind(c(0,0,0,0,0,0,0,0,0),n_sd[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")])
		bp <- barplot(plot_matrix,beside=T,col=c(cccol[2],cccol[1]),main=each,ylab="fpkm",names.arg=common_time_point,las=2,bty="l",border = NA,ylim=c(0,ymax*1.3))
		n <- c(2,2,2,3,3,3,2,2,2)
		error.bar(bp,plot_matrix, 1.96 * plot_sd / sqrt(n),col="black",length=0.02,lwd=1)
		legend("topleft",c("naive","primed"),col=c(cccol[1],cccol[2]),pch=15,bty="n")

	}
}
############################################################################
#########################	   read in data       ##########################
############################################################################

############ 2nd naive RNAseq
logfpkm2nd <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n8_r3","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")
nData_tmp <- logfpkm2nd[,n_path]
nfpkm2nd <- 2**nData_tmp - 1

n_time_point <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24p","n24m","niPS")
n_label <- c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T")
nData2ndfpkm <- cbind(apply(nfpkm2nd[,1:2],1,mean),apply(nfpkm2nd[,3:4],1,mean),apply(nfpkm2nd[,5:6],1,mean),apply(nfpkm2nd[,7:8],1,mean),apply(nfpkm2nd[,9:11],1,mean),apply(nfpkm2nd[,12:13],1,mean),apply(nfpkm2nd[,14:16],1,mean),apply(nfpkm2nd[,17:19],1,mean),apply(nfpkm2nd[,20:21],1,mean),apply(nfpkm2nd[,22:23],1,mean),apply(nfpkm2nd[,24:25],1,mean))
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)

############ 2nd primed RNAseq
pData2ndfpkm <- read.table("../data/paper.primed.fpkm.txt",header=T,row.names=1)

nData <- log2(nData2ndfpkm+1)
pData <- log2(pData2ndfpkm+1)
common_time_point <- c("hiF-T","2d","6d","8d","14d","20d","24d+dox","24d-dox","iPSC-T")
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)

############ Normalize
library(edgeR)
genes <- intersect(row.names(nData),row.names(pData))
paperpath <- c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")
all_data <- cbind(logfpkm2nd[genes,n_path],pData[genes,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")])
batch <- as.factor(c(rep(1,length(n_path)),rep(2,length(paperpath))))
rmbatch_data <- removeBatchEffect(all_data,batch=batch)

rmbatch_data[rmbatch_data<0] = 0
rmbatch_fpkm <- 2**rmbatch_data-1

nData <- cbind(apply(rmbatch_data[,1:2],1,mean),apply(rmbatch_data[,3:4],1,mean),apply(rmbatch_data[,5:6],1,mean),apply(rmbatch_data[,7:8],1,mean),apply(rmbatch_data[,9:11],1,mean),apply(rmbatch_data[,12:13],1,mean),apply(rmbatch_data[,14:16],1,mean),apply(rmbatch_data[,17:19],1,mean),apply(rmbatch_data[,20:21],1,mean),apply(rmbatch_data[,22:23],1,mean),apply(rmbatch_data[,24:25],1,mean))
colnames(nData) <- n_time_point
rownames(nData) <- genes
pData <- rmbatch_data[genes,paperpath]

pData2ndfpkm <- 2**pData - 1 
nData2ndfpkm <- 2**nData - 1 

n_sd <- cbind(apply(rmbatch_fpkm[,1:2],1,sd),apply(rmbatch_fpkm[,3:4],1,sd),apply(rmbatch_fpkm[,5:6],1,sd),apply(rmbatch_fpkm[,7:8],1,sd),apply(rmbatch_fpkm[,9:11],1,sd),apply(rmbatch_fpkm[,12:13],1,sd),apply(rmbatch_fpkm[,14:16],1,sd),apply(rmbatch_fpkm[,17:19],1,sd),apply(rmbatch_fpkm[,20:21],1,sd),apply(rmbatch_fpkm[,22:23],1,sd),apply(rmbatch_fpkm[,24:25],1,sd))
colnames(n_sd) <- n_time_point
rownames(n_sd) <- rownames(rmbatch_fpkm)
n_sd[n_sd < 0] <- 0
n_log_sd <- cbind(apply(rmbatch_data[,1:2],1,sd),apply(rmbatch_data[,3:4],1,sd),apply(rmbatch_data[,5:6],1,sd),apply(rmbatch_data[,7:8],1,sd),apply(rmbatch_data[,9:11],1,sd),apply(rmbatch_data[,12:13],1,sd),apply(rmbatch_data[,14:16],1,sd),apply(rmbatch_data[,17:19],1,sd),apply(rmbatch_data[,20:21],1,sd),apply(rmbatch_data[,22:23],1,sd),apply(rmbatch_data[,24:25],1,sd))
colnames(n_log_sd) <- n_time_point
rownames(n_log_sd) <- rownames(rmbatch_data)
n_log_sd[n_log_sd < 0] <- 0

############################################################################
#########################	         plot         ##########################
############################################################################

pdf("ACTA2.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("ACTA2")
dev.off()
pdf("CAV2.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("CAV2")
dev.off()
pdf("MEIS2.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("MEIS2")
dev.off()
pdf("CD44.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("CD44")
dev.off()
pdf("ALPPL2.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("ALPPL2")
dev.off()
pdf("ZSCAN4.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("ZSCAN4")
dev.off()
pdf("MBD3L.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot(c("MBD3L2","MBD3L3","MBD3L4","MBD3L5"))
dev.off()

CD_genes <- intersect(intersect(c("CD101","CD109","CD14","CD151","CD160","CD163","CD163L1","CD164","CD164L2","CD177","CD180","CD19","CD1A","CD1B","CD1C","CD1D","CD1E","CD2","CD200","CD200R1","CD200R1L","CD207","CD209","CD22","CD226","CD24","CD244","CD247","CD248","CD27","CD27-AS1","CD274","CD276","CD28","CD2AP","CD2BP2","CD300A","CD300C","CD300E","CD300LB","CD300LD","CD300LF","CD300LG","CD302","CD320","CD33","CD34","CD36","CD37","CD38","CD3D","CD3E","CD3EAP","CD3G","CD4","CD40","CD40LG","CD44","CD46","CD47","CD48","CD5","CD52","CD53","CD55","CD58","CD59","CD5L","CD6","CD63","CD68","CD69","CD7","CD70","CD72","CD74","CD79A","CD79B","CD80","CD81","CD81-AS1","CD82","CD83","CD84","CD86","CD8A","CD8B","CD9","CD93","CD96","CD97","CD99","CD99L2","CD99P1"),row.names(nData)),row.names(pData))
pdf("CD.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot(CD_genes)
dev.off()

pdf("ZNF534.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("ZNF534")
dev.off()

pdf("OTX2.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("OTX2")
dev.off()
pdf("ZIC2.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("ZIC2")
dev.off()
pdf("ZIC3.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("ZIC3")
dev.off()

# # cluster_8cell_genes is getting from Fig4B.r
# pdf("8C_genes.pdf",width=12,height=6)
# par(mar=c(8,4,4,2),mfcol=c(2,5))
# for(each in cluster_8cell_genes){
# 	NaivePrimedGeneBarplot(each)
# }
# dev.off()

pdf("ZNF641.pdf",width=4,height=5)
par(mar=c(8,4,4,2))
NaivePrimedGeneBarplot("ZNF641")
dev.off()

